import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BrandWikipediaIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-brand-wikipedia",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 4.984h2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 4.984h2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14.5 4.984h2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M22 4.984h-2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 4.984l5.455 14.516l6.545 -14.516"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 4.984l6 14.516l6 -14.516"
    }, null), _createTextVNode(" ")]);
  }
};