import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BrandWordpressIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-brand-wordpress",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9.5 9h3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 9h2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 9l3 11l4 -9"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5.5 9l3.5 11l3 -7"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 11c.177 -.528 1 -1.364 1 -2.5c0 -1.78 -.776 -2.5 -1.875 -2.5c-.898 0 -1.125 .812 -1.125 1.429c0 1.83 2 2.058 2 3.571z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"
    }, null), _createTextVNode(" ")]);
  }
};