import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BrandZapierIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-brand-zapier",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 12h6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 12h-6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 3v6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 15v6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5.636 5.636l4.243 4.243"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18.364 18.364l-4.243 -4.243"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18.364 5.636l-4.243 4.243"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9.879 14.121l-4.243 4.243"
    }, null), _createTextVNode(" ")]);
  }
};