import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BrightnessDownIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-brightness-down",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 5l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 7l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 12l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 17l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 19l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 17l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 12l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 7l0 .01"
    }, null), _createTextVNode(" ")]);
  }
};