import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BrushIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-brush",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 21v-4a4 4 0 1 1 4 4h-4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 3a16 16 0 0 0 -12.8 10.2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 3a16 16 0 0 1 -10.2 12.8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10.6 9a9 9 0 0 1 4.4 4.4"
    }, null), _createTextVNode(" ")]);
  }
};