import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BugIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-bug",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 9v-1a3 3 0 0 1 6 0v1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 9h8a6 6 0 0 1 1 3v3a5 5 0 0 1 -10 0v-3a6 6 0 0 1 1 -3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 13l4 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 13l4 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 20l0 -6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 19l3.35 -2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 19l-3.35 -2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 7l3.75 2.4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 7l-3.75 2.4"
    }, null), _createTextVNode(" ")]);
  }
};