import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BuildingCircusIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-building-circus",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 11h16"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 6.5c0 1 -5 4.5 -8 4.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 6.5c0 1 5 4.5 8 4.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 11c-.333 5.333 -1 8.667 -2 10h4c1 0 4 -4 4 -9v-1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 11c.333 5.333 1 8.667 2 10h-4c-1 0 -4 -4 -4 -9v-1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 7v-4l2 1h-2"
    }, null), _createTextVNode(" ")]);
  }
};