import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BuildingMosqueIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-building-mosque",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 21h7v-2a2 2 0 1 1 4 0v2h7"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 21v-10"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 21v-10"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 16h3v-3h10v3h3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 13a5 5 0 0 0 -10 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 10.5c0 -.329 -.077 -.653 -.224 -.947l-.776 -1.553l-.776 1.553a2.118 2.118 0 0 0 -.224 .947a.5 .5 0 0 0 .5 .5h1a.5 .5 0 0 0 .5 -.5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 10.5c0 -.329 -.077 -.653 -.224 -.947l-.776 -1.553l-.776 1.553a2.118 2.118 0 0 0 -.224 .947a.5 .5 0 0 0 .5 .5h1a.5 .5 0 0 0 .5 -.5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 2a2 2 0 1 0 2 2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 6v2"
    }, null), _createTextVNode(" ")]);
  }
};