import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BuildingTunnelIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-building-tunnel",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 21h14a2 2 0 0 0 2 -2v-7a9 9 0 0 0 -18 0v7a2 2 0 0 0 2 2z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 21v-9a4 4 0 1 1 8 0v9"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 17h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 17h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 12h-4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 12h-4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 3v5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 6l3 3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 9l3 -3l-3 3z"
    }, null), _createTextVNode(" ")]);
  }
};