import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BulldozerIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-bulldozer",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M2 17a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 17a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 13v4a2 2 0 0 0 2 2h1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 19h-10"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 15h10"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 11v-5h2a3 3 0 0 1 3 3v6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 15v-3a1 1 0 0 1 1 -1h8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 17h-3"
    }, null), _createTextVNode(" ")]);
  }
};