import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BusStopIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-bus-stop",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 5h7c2.761 0 5 3.134 5 7v5h-2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 17h-8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 5l1.5 7h4.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9.5 10h7.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 5v5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 9v11"
    }, null), _createTextVNode(" ")]);
  }
};