import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'CarTurbineIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-car-turbine",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 13m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18.86 11c.088 .66 .14 1.512 .14 2a8 8 0 1 1 -8 -8h6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 9c2.489 .108 4.489 .108 6 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 3m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 13l-3.5 -1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 13l2.5 3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8.5 16l2.5 -3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 13l3.5 -1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 9v4"
    }, null), _createTextVNode(" ")]);
  }
};