import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'CeOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-ce-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 4a7.99 7.99 0 0 0 -2.581 .426"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5.867 5.864a8 8 0 0 0 5.133 14.136"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 4a8 8 0 0 0 -7.29 4.7"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 12a8 8 0 0 0 8 8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 12h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};