import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'ChartHistogramIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-chart-histogram",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3v18h18"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 18v3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 16v5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 13v8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 16v5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 11c6 0 5 -5 9 -5s3 5 9 5"
    }, null), _createTextVNode(" ")]);
  }
};