import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'ChartRadarIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-chart-radar",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 3l9.5 7l-3.5 11h-12l-3.5 -11z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 7.5l5.5 4l-2.5 5.5h-6.5l-2 -5.5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M2.5 10l9.5 3l9.5 -3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 3v10l6 8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 21l6 -8"
    }, null), _createTextVNode(" ")]);
  }
};