import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'CpuOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-cpu-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 5h9a1 1 0 0 1 1 1v9m-.292 3.706a1 1 0 0 1 -.708 .294h-12a1 1 0 0 1 -1 -1v-12c0 -.272 .108 -.518 .284 -.698"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 9h2v2m0 4h-6v-6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 10h2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 14h2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 3v2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 3v2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 10h-2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 14h-2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 21v-2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 21v-2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};