import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'CreditCardOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-credit-card-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 5h9a3 3 0 0 1 3 3v8a3 3 0 0 1 -.128 .87"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18.87 18.872a3 3 0 0 1 -.87 .128h-12a3 3 0 0 1 -3 -3v-8c0 -1.352 .894 -2.495 2.124 -2.87"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 11l8 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 11l6 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 15l.01 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 15l2 0"
    }, null), _createTextVNode(" ")]);
  }
};