import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'CurrencyDirhamIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-currency-dirham",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8.5 19h-3.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8.599 16.479a1.5 1.5 0 1 0 -1.099 2.521"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 4v9"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 13h1.888a1.5 1.5 0 0 0 1.296 -2.256l-2.184 -3.744"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 13.01v-.01"
    }, null), _createTextVNode(" ")]);
  }
};