import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'CurrencyIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-currency",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 12m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 4l3 3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 4l-3 3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 20l3 -3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 20l-3 -3"
    }, null), _createTextVNode(" ")]);
  }
};