import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'CurrencyIranianRialIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-currency-iranian-rial",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 4v9a2 2 0 0 1 -2 2h-1a3 3 0 0 1 -3 -3v-1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 5v8a1 1 0 0 0 1 1h1a2 2 0 0 0 2 -2v-1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 14v1.096a5 5 0 0 1 -3.787 4.85l-.213 .054"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 18h.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 18h.01"
    }, null), _createTextVNode(" ")]);
  }
};