import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'DeviceImacPlusIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-device-imac-plus",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12.5 17h-8.5a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 13h13.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 21h4.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 17l-.5 4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 19h6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 16v6"
    }, null), _createTextVNode(" ")]);
  }
};