import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'DeviceImacXIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-device-imac-x",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 17h-9a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v9"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 13h18"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 21h5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 17l-.5 4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M22 22l-5 -5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 22l5 -5"
    }, null), _createTextVNode(" ")]);
  }
};