import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'DeviceLandlinePhoneIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-device-landline-phone",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 3h-2a2 2 0 0 0 -2 2v14a2 2 0 0 0 2 2h2a2 2 0 0 0 2 -2v-14a2 2 0 0 0 -2 -2z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 4h-11a3 3 0 0 0 -3 3v10a3 3 0 0 0 3 3h11"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 8h-6v3h6z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 14v.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 14v.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 14v.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 17v.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 17v.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 17v.01"
    }, null), _createTextVNode(" ")]);
  }
};