import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'DeviceSimIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-device-sim",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 3h8.5l4.5 4.5v12.5a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1v-16a1 1 0 0 1 1 -1z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 11h3v6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 17v.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 14v.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 11v.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 14v.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 17v.01"
    }, null), _createTextVNode(" ")]);
  }
};