import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'DirectionsIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-directions",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 21v-4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 13v-4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 5v-2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 21h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 5v4h11l2 -2l-2 -2z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 13v4h-8l-2 -2l2 -2z"
    }, null), _createTextVNode(" ")]);
  }
};