import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'DiscGolfIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-disc-golf",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 5h14"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 5c.32 6.744 2.74 9.246 6 10"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 5c-.32 6.744 -2.74 9.246 -6 10"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 5c0 4.915 .552 7.082 2 10"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 5c0 4.915 -.552 7.082 -2 10"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 15v6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 3v2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 16c.64 .64 1.509 1 2.414 1h5.172c.905 0 1.774 -.36 2.414 -1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 21h2"
    }, null), _createTextVNode(" ")]);
  }
};