import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'DragDropIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-drag-drop",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 11v-2a2 2 0 0 0 -2 -2h-8a2 2 0 0 0 -2 2v8a2 2 0 0 0 2 2h2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 13l9 3l-4 2l-2 4l-3 -9"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 3l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 3l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 3l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 7l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 11l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 15l0 .01"
    }, null), _createTextVNode(" ")]);
  }
};