import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'DropletCogIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-droplet-cog",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18.421 11.56a6.702 6.702 0 0 0 -.357 -.683l-4.89 -7.26c-.42 -.625 -1.287 -.803 -1.936 -.397a1.376 1.376 0 0 0 -.41 .397l-4.893 7.26c-1.695 2.838 -1.035 6.441 1.567 8.546a7.144 7.144 0 0 0 4.518 1.58"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19.001 15.5v1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19.001 21v1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M22.032 17.25l-1.299 .75"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17.27 20l-1.3 .75"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15.97 17.25l1.3 .75"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20.733 20l1.3 .75"
    }, null), _createTextVNode(" ")]);
  }
};