import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'EmergencyBedIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-emergency-bed",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 18m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 18m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 8l2.1 2.8a3 3 0 0 0 2.4 1.2h11.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 6h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 4v4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 12v2l-2.5 2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14.5 16.5l-2.5 -2.5"
    }, null), _createTextVNode(" ")]);
  }
};