import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'EyeClosedIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-eye-closed",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 9c-2.4 2.667 -5.4 4 -9 4c-3.6 0 -6.6 -1.333 -9 -4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 15l2.5 -3.8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 14.976l-2.492 -3.776"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 17l.5 -4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 17l-.5 -4"
    }, null), _createTextVNode(" ")]);
  }
};