import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'EyeCogIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-eye-cog",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 18c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19.001 15.5v1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19.001 21v1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M22.032 17.25l-1.299 .75"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17.27 20l-1.3 .75"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15.97 17.25l1.3 .75"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20.733 20l1.3 .75"
    }, null), _createTextVNode(" ")]);
  }
};