import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'EyeTableIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-eye-table",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 18h-.011"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 18h-.011"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 18h-.011"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 3h16"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 3v17a1 1 0 0 0 1 1h12a1 1 0 0 0 1 -1v-17"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 7h-4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 15h1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 15h1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 11v-4"
    }, null), _createTextVNode(" ")]);
  }
};