import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'FenceOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-fence-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 12h-8v4h12m4 0v-4h-4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 16v4h4v-4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 12v-2m0 -4l-2 -2m-2 2v6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 16v4h4v-2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 12v-6l-2 -2l-2 2v4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};