import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'FileZipIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-file-zip",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 20.735a2 2 0 0 1 -1 -1.735v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2h-1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 17a2 2 0 0 1 2 2v2a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-2a2 2 0 0 1 2 -2z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 5l-1 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 7l-1 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 9l-1 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 11l-1 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 13l-1 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 15l-1 0"
    }, null), _createTextVNode(" ")]);
  }
};