import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'FreeRightsIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-free-rights",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13.867 9.75c-.246 -.48 -.708 -.769 -1.2 -.75h-1.334c-.736 0 -1.333 .67 -1.333 1.5c0 .827 .597 1.499 1.333 1.499h1.334c.736 0 1.333 .671 1.333 1.5c0 .828 -.597 1.499 -1.333 1.499h-1.334c-.492 .019 -.954 -.27 -1.2 -.75"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 7v2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 15v2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 6l1.5 1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16.5 16.5l1.5 1.5"
    }, null), _createTextVNode(" ")]);
  }
};