import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'GaugeOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-gauge-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20.038 16.052a9 9 0 0 0 -12.067 -12.102m-2.333 1.686a9 9 0 1 0 12.73 12.726"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11.283 11.303a1 1 0 0 0 1.419 1.41"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 10l2 -2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 12c0 -1.386 .564 -2.64 1.475 -3.546m2.619 -1.372c.294 -.054 .597 -.082 .906 -.082"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};