import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'GenderGenderfluidIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-gender-genderfluid",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 15.464a4 4 0 1 0 4 -6.928a4 4 0 0 0 -4 6.928z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15.464 14l3 -5.196"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5.536 15.195l3 -5.196"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 12h.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 9l-6 -6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5.5 8.5l3 -3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 21l-6 -6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 20l3 -3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 7v-4h4"
    }, null), _createTextVNode(" ")]);
  }
};