import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'GenderIntergenderIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-gender-intergender",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13.5 11.5l6.5 6.5v-4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11.5 13.5l6.5 6.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 4a5 5 0 1 1 0 10a5 5 0 0 1 0 -10z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 20l2 -2"
    }, null), _createTextVNode(" ")]);
  }
};