import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'GenderTransgenderIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-gender-transgender",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 12m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 9l6 -6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 7v-4h-4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 9l-6 -6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 7v-4h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5.5 8.5l3 -3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 16v5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9.5 19h5"
    }, null), _createTextVNode(" ")]);
  }
};