import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'GrillIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-grill",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 8h-14a6 6 0 0 0 6 6h2a6 6 0 0 0 6 -5.775l0 -.225z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 20a2 2 0 1 1 0 -4a2 2 0 0 1 0 4z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 14l1 2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 14l-3 6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 18h-8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 5v-1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 5v-1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 5v-1"
    }, null), _createTextVNode(" ")]);
  }
};