import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'GrillOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-grill-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 8h-3a6 6 0 0 0 6 6h2c.315 0 .624 -.024 .926 -.071m2.786 -1.214a5.99 5.99 0 0 0 2.284 -4.49l0 -.225h-7"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18.827 18.815a2 2 0 1 1 -2.663 -2.633"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 14l-3 6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 18h-8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 5v-1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 5v-1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 5v-1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};