import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'H6Icon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-h-6",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 14a2 2 0 1 0 0 4a2 2 0 0 0 0 -4z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 12a2 2 0 1 0 -4 0v4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 6v12"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 6v12"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 18h2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 18h2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 12h8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 6h2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 6h2"
    }, null), _createTextVNode(" ")]);
  }
};