import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'HelicopterIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-helicopter",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 10l1 2h6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 9a2 2 0 0 0 -2 2v3c0 1.1 .9 2 2 2h7a2 2 0 0 0 2 -2c0 -3.31 -3.13 -5 -7 -5h-2z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 9l0 -3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 6l15 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 9.1v3.9h5.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 19l0 -3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 19l-8 0"
    }, null), _createTextVNode(" ")]);
  }
};