import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'HomeCogIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-home-cog",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 21v-6a2 2 0 0 1 2 -2h1.6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 11l-8 -8l-9 9h2v7a2 2 0 0 0 2 2h4.159"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 18m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 14.5v1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 20v1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21.032 16.25l-1.299 .75"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16.27 19l-1.3 .75"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14.97 16.25l1.3 .75"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19.733 19l1.3 .75"
    }, null), _createTextVNode(" ")]);
  }
};