import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'HomeEcoIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-home-eco",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 11l-8 -8l-9 9h2v7a2 2 0 0 0 2 2h5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 21v-6a2 2 0 0 1 2 -2h2c.325 0 .631 .077 .902 .215"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 22s0 -2 3 -4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 21a3 3 0 0 1 0 -6h3v3a3 3 0 0 1 -3 3z"
    }, null), _createTextVNode(" ")]);
  }
};