import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'JetpackIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-jetpack",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 6a3 3 0 1 0 -6 0v7h6v-7z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 13h6v-7a3 3 0 0 0 -6 0v7z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 16c0 2.333 .667 4 2 5c1.333 -1 2 -2.667 2 -5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 16c0 2.333 .667 4 2 5c1.333 -1 2 -2.667 2 -5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 8h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 11h4"
    }, null), _createTextVNode(" ")]);
  }
};