import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'LadderOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-ladder-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 3v1m0 4v13"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 3v9m0 4v5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 14h6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 10h2m4 0h2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 6h6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 18h8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};