import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'LanguageKatakanaIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-language-katakana",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 5h6.586a1 1 0 0 1 .707 1.707l-1.293 1.293"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 8c0 1.5 .5 3 -2 5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 20l4 -9l4 9"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19.1 18h-6.2"
    }, null), _createTextVNode(" ")]);
  }
};