import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'LanguageOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-language-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 5h1m4 0h2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 3v2m-.508 3.517c-.814 2.655 -2.52 4.483 -4.492 4.483"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 9c0 2.144 2.952 3.908 6.7 4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 20l2.463 -5.541m1.228 -2.764l.309 -.695l.8 1.8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 18h-5.1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};