import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'LetterSpacingIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-letter-spacing",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 12v-5.5a2.5 2.5 0 0 1 5 0v5.5m0 -4h-5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 4l3 8l3 -8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 18h14"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 20l2 -2l-2 -2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 16l-2 2l2 2"
    }, null), _createTextVNode(" ")]);
  }
};